//
// Copyright (C) 2006 Henning Westerholt
// Copyright (C) 2000 Institut fuer Telematik, Universitaet Karlsruhe
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//

#include <omnetpp.h>
#include "EtherStreamSink.h"
#include "EtherApp_m.h"
#include "Ieee802Ctrl_m.h"

Define_Module(EtherStreamSink);


void EtherStreamSink::initialize()
{
    packetsReceived = 0;
    WATCH(packetsReceived);

    localSAP = ETHERAPP_SRV_SAP;
    registerDSAP(localSAP);
}

void EtherStreamSink::registerDSAP(const int dsap)
{
    EV << fullPath() << " registering DSAP " << dsap << "\n";

    Ieee802Ctrl *etherctrl = new Ieee802Ctrl();
    etherctrl->setDsap(dsap);
    cMessage *msg = new cMessage("register_DSAP", IEEE802CTRL_REGISTER_DSAP);
    msg->setControlInfo(etherctrl);

    send(msg, "out");
}


void EtherStreamSink::handleMessage(cMessage *msg)
{
    receivePacket(msg);
}

void EtherStreamSink::receivePacket(cMessage *msg)
{
    EV << "Received packet `" << msg->name() << "'\n";
    packetsReceived++;
    delete msg;
}

void EtherStreamSink::finish()
{
    if (par("writeScalars").boolValue())
    {
        recordScalar("packets rcvd", packetsReceived);
    }
}
