<?xml version="1.0" encoding="UTF-8"?>

<!--
 Copyright (C) 2006 Henning Westerholt

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along
 with this program; if not, write to the Free Software Foundation, Inc.,
 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
-->

<!--
* simple xml modification introduction: http://www.xml.com/pub/a/2000/06/07/transforming/index.html
* xml reference: http://www.xsl-rp.de/index.php?page=XSLT-Doku
* another reference: http://de.selfhtml.org/xml/darstellung/xsltelemente.htm
* for XPath etc.. and more information  refer to the Skonnard Book
-->

<!-- Stylesheet to create network definition for a INET/ OMNeT++ network.
     Use this with e.g. xsltproc (from the libxslt package).
     Usage: xsltproc -o $OUTPUT network.xsl $INPUT
     The input file must be valid XML network in the "PG"-format.
-->

<!-- setup xml -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="xml" version="1.0" indent="yes" encoding="UTF-8"/>

<!-- strip whitespaces -->
<xsl:strip-space elements="*"/>

<xsl:template match="/">
    <xsl:apply-templates/>
</xsl:template>

<!-- match the PG XML Header -->
<xsl:template match="NetStDTD">
<!-- add necessary imports for omnet++ -->
<xsl:comment>network definition for a INET/ OMNeT++ network</xsl:comment>
<ned-file><xsl:attribute name="filename">Todo</xsl:attribute>
    <import>
        <imported-file filename="EtherHost"/>
        <imported-file filename="EtherHostTDMA"/>
        <imported-file filename="EtherSwitchTDMA"/>
    </import>

<!-- TODO we need a network name here, perhaps we can introduce a field in the PG-XML? -->
    <compound-module><xsl:attribute name="name">MixedLAN</xsl:attribute>
    <xsl:apply-templates/>
    </compound-module>
    <!-- TODO network name and simple module name is missing here -->
    <network><xsl:attribute name="name">mixedLAN</xsl:attribute><xsl:attribute name="type-name">MixedLAN</xsl:attribute></network>
    <simple-module><xsl:attribute name="name">Simple</xsl:attribute></simple-module>
</ned-file>
</xsl:template>

<!-- match the switches block -->
<xsl:template match="Switches">
<submodules>
    <xsl:apply-templates/>
</submodules>
</xsl:template>

<!-- rename the hardware node -->
<xsl:template match="Hardware">
<!-- replace attributes -->
<submodule>
    <xsl:choose>
        <xsl:when test="@Type = 'RTSwitch'">
            <!-- replace attributes, first Id -> name -->
            <!-- omnet++ names must start with an letter or an underscore -->
            <xsl:attribute name="name"><xsl:value-of select="concat('switch_', @Id)"/></xsl:attribute>
            <!-- Type -> type-name -->
            <xsl:attribute name="type-name">EtherSwitchTDMA</xsl:attribute>
            <gatesizes>
                <gatesize><xsl:attribute name="name">in</xsl:attribute>
                    <expression><xsl:attribute name="target">vector-size</xsl:attribute>
                        <const>
                            <xsl:attribute name="type">int</xsl:attribute>
                            <xsl:attribute name="value"><xsl:value-of select="@Ports"/></xsl:attribute>
                        </const>
                    </expression>
                </gatesize>
                <gatesize><xsl:attribute name="name">out</xsl:attribute>
                    <expression><xsl:attribute name="target">vector-size</xsl:attribute>
                        <const>
                            <xsl:attribute name="type">int</xsl:attribute>
                            <xsl:attribute name="value"><xsl:value-of select="@Ports"/></xsl:attribute>
                        </const>
                    </expression>
                </gatesize>
            </gatesizes>
            <!-- position attribute of display string is missing here, but omnet++ chooses a random position -->
            <display-string><xsl:attribute name="value">i=switch2</xsl:attribute></display-string>
        </xsl:when>
        <xsl:when test="@Type = 'NetDevice'">
            <xsl:attribute name="name"><xsl:value-of select="concat('device_', @Id)"/></xsl:attribute>
            <xsl:attribute name="type-name">EtherHost</xsl:attribute>
            <display-string><xsl:attribute name="value">i=device/laptop</xsl:attribute></display-string>
        </xsl:when>
        <xsl:otherwise>
            <xsl:attribute name="name"><xsl:value-of select="concat('device_', @Id)"/></xsl:attribute>
            <xsl:attribute name="type-name">EtherHostTDMA</xsl:attribute>
            <display-string><xsl:attribute name="value">i=device/pc2</xsl:attribute></display-string>
        </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates/>
</submodule>
</xsl:template>

<!-- do nothing with the ports and port nodes -->
<xsl:template match="Ports"/>
<xsl:template match="Port"/>

<xsl:template match="Links">
<connections>
    <xsl:apply-templates/>
</connections>
</xsl:template>

<!-- create the connection nodes -->
<xsl:template match="Link">

<!-- assign a variable to the current ToDeviceId Attribute -->
<xsl:variable name="toDevice" select="@ToDeviceId"/>"

<!-- first the one direction, switch to device, or switch to switch -->
<xsl:choose>
    <!-- switch to switch -->
    <!-- get the hardware node with id = toDeviceId, test if this is a RTSwitch -->
    <xsl:when test="/NetStDTD/Switches/Hardware[@Id = $toDevice]/@Type = 'RTSwitch'">
    <connection>
        <xsl:attribute name="src-module"><xsl:value-of select="concat('switch_', @ToDeviceId)"/></xsl:attribute>
        <xsl:attribute name="src-gate">out</xsl:attribute>
        <xsl:attribute name="dest-module"><xsl:value-of select="concat('switch_', @FromDeviceId)"/></xsl:attribute>
        <xsl:attribute name="dest-gate">in</xsl:attribute>
        <expression><xsl:attribute name="target">src-gate-index</xsl:attribute>
            <const>
                <xsl:attribute name="type">int</xsl:attribute>
                <xsl:attribute name="value"><xsl:value-of select="@ToPort"/></xsl:attribute>
            </const>
        </expression>
        <expression><xsl:attribute name="target">dest-gate-index</xsl:attribute>
            <const>
                <xsl:attribute name="type">int</xsl:attribute>
                <xsl:attribute name="value"><xsl:value-of select="@FromPort"/></xsl:attribute>
            </const>
        </expression>
        <conn-attr><xsl:attribute name="name">delay</xsl:attribute>
            <expression><xsl:attribute name="target">value</xsl:attribute>
                <const>
                    <xsl:attribute name="type">time</xsl:attribute>
                    <xsl:attribute name="text"><xsl:value-of select="concat(@Delay, 'us')"/></xsl:attribute>
                    <xsl:attribute name="value"><xsl:value-of select="@Delay"/></xsl:attribute>
                </const>
            </expression>
        </conn-attr>
    </connection>
    </xsl:when>
    <!-- switch to device -->
    <xsl:otherwise>
    <connection>
        <xsl:attribute name="src-module"><xsl:value-of select="concat('switch_', @FromDeviceId)"/></xsl:attribute>
        <xsl:attribute name="src-gate">out</xsl:attribute>
        <xsl:attribute name="dest-module"><xsl:value-of select="concat('device_', @ToDeviceId)"/></xsl:attribute>
        <xsl:attribute name="dest-gate">in</xsl:attribute>
        <!-- default arrow-direction is right -->
        <expression><xsl:attribute name="target">src-gate-index</xsl:attribute>
            <const>
                <xsl:attribute name="type">int</xsl:attribute>
                <xsl:attribute name="value"><xsl:value-of select="@FromPort"/></xsl:attribute>
            </const>
        </expression>
        <conn-attr><xsl:attribute name="name">delay</xsl:attribute>
            <expression><xsl:attribute name="target">value</xsl:attribute>
                <const>
                    <xsl:attribute name="type">time</xsl:attribute>
                    <xsl:attribute name="text"><xsl:value-of select="concat(@Delay, 'us')"/></xsl:attribute>
                    <xsl:attribute name="value"><xsl:value-of select="@Delay"/></xsl:attribute>
                </const>
            </expression>
        </conn-attr>
    </connection>
</xsl:otherwise>
</xsl:choose>

<!-- and then the other.., device to switch, or switch to switch -->
<xsl:choose>
     <!-- switch to switch -->
    <xsl:when test="/NetStDTD/Switches/Hardware[@Id = $toDevice]/@Type = 'RTSwitch'">
    <connection>
        <xsl:attribute name="src-module"><xsl:value-of select="concat('switch_', @FromDeviceId)"/></xsl:attribute>
        <xsl:attribute name="src-gate">out</xsl:attribute>
        <xsl:attribute name="dest-module"><xsl:value-of select="concat('switch_', @ToDeviceId)"/></xsl:attribute>
        <xsl:attribute name="dest-gate">in</xsl:attribute>
        <xsl:attribute name="arrow-direction">left</xsl:attribute>
        <expression><xsl:attribute name="target">src-gate-index</xsl:attribute>
            <const>
                <xsl:attribute name="type">int</xsl:attribute>
                <xsl:attribute name="value"><xsl:value-of select="@FromPort"/></xsl:attribute>
            </const>
        </expression>
        <expression><xsl:attribute name="target">dest-gate-index</xsl:attribute>
            <const>
                <xsl:attribute name="type">int</xsl:attribute>
                <xsl:attribute name="value"><xsl:value-of select="@ToPort"/></xsl:attribute>
            </const>
        </expression>
        <conn-attr><xsl:attribute name="name">delay</xsl:attribute>
            <expression><xsl:attribute name="target">value</xsl:attribute>
                <const>
                    <xsl:attribute name="type">time</xsl:attribute>
                    <xsl:attribute name="text"><xsl:value-of select="concat(@Delay, 'us')"/></xsl:attribute>
                    <xsl:attribute name="value"><xsl:value-of select="@Delay"/></xsl:attribute>
                </const>
            </expression>
        </conn-attr>
    </connection>
    </xsl:when>
<!-- device to switch -->
<xsl:otherwise>
    <connection>
        <xsl:attribute name="src-module"><xsl:value-of select="concat('device_', @ToDeviceId)"/></xsl:attribute>
        <xsl:attribute name="src-gate">out</xsl:attribute>
        <xsl:attribute name="dest-module"><xsl:value-of select="concat('switch_', @FromDeviceId)"/></xsl:attribute>
        <xsl:attribute name="dest-gate">in</xsl:attribute>
        <xsl:attribute name="arrow-direction">left</xsl:attribute>
        <expression><xsl:attribute name="target">dest-gate-index</xsl:attribute>
            <const>
                <xsl:attribute name="type">int</xsl:attribute>
                <xsl:attribute name="value"><xsl:value-of select="@FromPort"/></xsl:attribute>
            </const>
        </expression>
        <conn-attr><xsl:attribute name="name">delay</xsl:attribute>
            <expression><xsl:attribute name="target">value</xsl:attribute>
                <const>
                    <xsl:attribute name="type">time</xsl:attribute>
                    <xsl:attribute name="text"><xsl:value-of select="concat(@Delay, 'us')"/></xsl:attribute>
                    <xsl:attribute name="value"><xsl:value-of select="@Delay"/></xsl:attribute>
                </const>
            </expression>
        </conn-attr>
    </connection>
    </xsl:otherwise>
</xsl:choose>
</xsl:template>

<xsl:template match="Messages"/>

</xsl:stylesheet>
