<?xml version="1.0" encoding="UTF-8"?>

<!--
 Copyright (C) 2006 Henning Westerholt

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along
 with this program; if not, write to the Free Software Foundation, Inc.,
 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
-->

<!-- Stylesheet to create schedule definition for a INET/ OMNeT++ network.
     Use this with e.g. xsltproc (from the libxslt package).
     Usage: xsltproc -o $OUTPUT schedule.xsl $INPUT
     The input file must be valid XML schedule, communicationline and network
     file in the "PG"-format
-->

<!-- setup xml -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="xml" version="1.0" indent="yes" encoding="UTF-8"/>

<!-- strip whitespaces -->
<xsl:strip-space elements="*"/>

<xsl:template match="/">
    <xsl:comment>schedule definition for a INET/ OMNeT++ network</xsl:comment>
<!-- placeholder attribute -->
    <schedule><xsl:attribute name="timeSlotCount"/>
    <xsl:apply-templates/>
</schedule>
</xsl:template>

<xsl:template match="temp-file">
    <xsl:apply-templates/>
</xsl:template>

<!-- match schedules, add comment and start tag -->
<xsl:template match="schedules">
    <xsl:apply-templates/>
</xsl:template>

<!-- add the switch -->
<xsl:template match="distributor">
    <switch>
        <xsl:attribute name="id"><xsl:value-of select="concat('switch_', @id)"/></xsl:attribute>
<!--        <xsl:attribute name="portCount"><xsl:value-of select="/temp-file/NetStDTD/Switches/Hardware[@Id = current()/@id]/@Ports"/></xsl:attribute> -->
        <xsl:apply-templates/>
    </switch>
</xsl:template>

<!-- no "apply-templates" in this template allowed, otherwise the communicationLine template below would be matched -->
<xsl:template match="timeSlot">
        <timeSlot>
            <xsl:attribute name="id"><xsl:value-of select="@id"/></xsl:attribute>

<!-- loop over the children of the timeSlot node -->
        <xsl:for-each select="current()/communicationLine">

<!-- and get the input/ output ports from the communicationLine distributor  -->
<!-- get the communicationLine where the id is equal this communicationLine id, and the distributor child
        with the id equals the distributor of the grand-parent of this communicationLine -->
            <connection>
            <xsl:attribute name="out"><xsl:value-of select="/temp-file/communicationLines/communicationLine[@id = current()/@ID]/distributor[@Id = current()/../../@id]/outputPort"/></xsl:attribute>
            <xsl:attribute name="in"><xsl:value-of select="/temp-file/communicationLines/communicationLine[@id = current()/@ID]/distributor[@Id = current()/../../@id]/inputPort"/></xsl:attribute>
            </connection>
        </xsl:for-each>
        </timeSlot>
</xsl:template>

<xsl:template match="communicationLines">
    <xsl:apply-templates/>
</xsl:template>

<!-- add time slot ids for the normal devices -->
<xsl:template match="communicationLine">

<!-- loop over the children of the communicationLine node -->
        <xsl:for-each select="current()/distributor">
<!-- cache the link to device id and the size of this attribute in variables to reduce the redundant processing,
       as this loop process evaluate many nodess -->
            <xsl:variable name="linkToDeviceId" select="/temp-file/NetStDTD/Links/Link[@FromPort = current()/inputPort and @FromDeviceId = current()/@Id]/@ToDeviceId"/>
            <xsl:variable  name="linkSize" select="string-length($linkToDeviceId)"/>
<!-- skip communication lines without any device nodes -->
           <xsl:choose>
                <xsl:when test="$linkSize = 0">
<!-- do nothing -->
                </xsl:when>
<!-- process the other lines, but skip any of them without any traffic associated -->
                <xsl:when test="$linkSize > 0 and string-length(/temp-file/NetStDTD/Messages/Message[@SenderId = $linkToDeviceId]/@SenderId) > 0">
<!-- first get the device id, this is the ToDeviceId attribute from the link with FromPort equals the
        distributors inputPort, and the FromDeviceId from the link equals the distributor id-->
                    <device>
                        <xsl:attribute name="id"><xsl:value-of select="concat('device_', $linkToDeviceId)"/></xsl:attribute>
<!-- get the slotId, for this we need the parent (communicationLine) id, and look this up at the
        schedule timeslot node from the right distributor. The parent id (timeSlot) is the right value -->
                        <xsl:attribute name="slotId"><xsl:value-of select="/temp-file/schedules/distributor[@id = current()/@Id]/timeSlot/communicationLine[@ID = current()/../@id]/../@id"/></xsl:attribute>
                    </device>
                </xsl:when>
            </xsl:choose>
        </xsl:for-each>
</xsl:template>

<!-- ignore the network stuff -->
<xsl:template match="NetStDTD"/>
<xsl:template match="Switches"/>
<xsl:template match="Hardware"/>
<xsl:template match="Links"/>
<xsl:template match="Messages"/>

</xsl:stylesheet>
