//
// Copyright (C) 2006 Henning Westerholt
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//  
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along
// with this program; if not, write to the Free Software Foundation, Inc.,
// 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
//

#ifndef _HARDWARE_H_
#define _HARDWARE_H_

#include <QString>
#include <ports.h>

class Hardware
{
    public:
        Hardware() : id(0), uploadPortNumber(0), bandwith(0), name(), mode(), mac(), type() {}

        unsigned long getId() const { return id; }
        void setId(const unsigned long id) { this->id = id; }
        long getUploadPortNumber() const { return uploadPortNumber; }
        void setUploadPortNumber(const long uploadPortNumber) { this->uploadPortNumber = uploadPortNumber; }
        double getBandwith() const { return bandwith; }
        void setBandwith(const double bandwith) { this->bandwith = bandwith; }
        const QString& getName() const { return name; }
        void setName(const QString& name) { this->name = name; }        
        const QString& getMode() const { return mode; }
        void setMode(const QString& mode) { this->mode = mode; }
        const QString& getMac() const { return mac; }
        void setMac(const QString& mac) { this->mac = mac; }
        const QString& getType() const { return type; }
        void setType(const QString& type) { this->type = type; }
        const Ports& getPorts() const { return ports; }
        //void setPorts(const Ports& ports) { this->ports = ports; }
        void appendPort(const Port& port) { ports.append(port); }

    private:
        unsigned long id;
        long uploadPortNumber;
        double bandwith;
        QString name, mode, mac, type;
        Ports ports;
};

#endif
