//
// Copyright (C) 2006 Henning Westerholt
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//  
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along
// with this program; if not, write to the Free Software Foundation, Inc.,
// 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
//

#ifndef _LINKS_H_
#define _LINKS_H_

#include <QList>

class Link
{
    public:
        Link() : fromDevice(0), toDevice(0), toPort(0), fromPort(0), delay(0) {}
        void setFromDevice(const unsigned int fromDevice) { this->fromDevice = fromDevice; }
        unsigned int getFromDevice() const { return fromDevice; }
        void setToDevice(const unsigned int toDevice) { this->toDevice = toDevice; }
        unsigned int getToDevice() const { return toDevice; }
        void setToPort (const unsigned int toPort) { this->toPort = toPort; }
        unsigned int getToPort() const { return toPort; }
        void setFromPort(const unsigned int fromPort) { this->fromPort = fromPort; }
        unsigned int getFromPort() const { return fromPort; }
        void setDelay(const int delay) { this->delay = delay; }
        int getDelay() const { return delay; }

    private:
        unsigned int fromDevice, toDevice, toPort, fromPort, delay;
};

class Links : public QList<Link> { };

#endif
