//
// Copyright (C) 2006 Henning Westerholt
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//  
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along
// with this program; if not, write to the Free Software Foundation, Inc.,
// 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
//

#ifndef _NETWORK_H_
#define _NETWORK_H_

#include <tree.hh>

class Hardware;
class Port;
class Utility;
class Links;
class Link;
class Messages;
class Message;

enum TrafficMode
{
    Random,
    Master,
    MultiMaster,
    Invalid
};

class NetworkParameter
{
    public:
        NetworkParameter();

        // network parameter
        unsigned int networkSize;
        double siblingChance;
        double connectionChance;
        double connectionRange;
        double normalDeviceChance;
        unsigned int randomSeed;
        TrafficMode trafficMode;
        bool valid;
};

class Network
{
    public:
        Network(const NetworkParameter& parameter);
        ~Network();
        void createNetwork();
        const tree<Hardware> * getTree() const;
        const Links * getLinks() const;
        const Messages * getMessages() const;
        void printTree() const;

    private:
        // disable compiler generated constructor, copy constructor and operator=
        Network();
        Network(const Network&);
        void operator=(const Network& other);

        void createTree();
        void decorateTree();
        void connectTree();
        Hardware createHardware() const;
        Port createPort() const;
        Link createLink() const;
        Message createMessage() const;

        NetworkParameter parameter;

        tree<Hardware>* myTree;
        Links * myLinks;
        Messages * myMessages;
        Utility* utility;
};

#endif
