//
// Copyright (C) 2006 Henning Westerholt
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//  
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along
// with this program; if not, write to the Free Software Foundation, Inc.,
// 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
//

#include <QtXml>
#include <tree.hh>
#include <xmlgenerator.h>
#include <hardware.h>
#include <links.h>
#include <messages.h>
#include <network.h>

XMLGenerator::XMLGenerator() : doc(new QDomDocument)
{
    QDomElement root = doc->createElement("NetStDTD");
    doc->appendChild(root);
}

XMLGenerator:: ~XMLGenerator()
{
    delete doc;
}

void XMLGenerator::addNetwork(const Network& network)
{
    QDomElement root = doc->documentElement();

    const tree<Hardware> * tr = network.getTree();
    tree<Hardware>::iterator iter = tr->begin();

    QDomElement switches = doc->createElement("Switches");
    root.appendChild(switches);

    // create the hardware sub elements
    while (iter != tr->end()) {
        // get the basic attributes
        QDomElement hardware = doc->createElement("Hardware");
        hardware.setAttribute("Id", (quint32)  (*iter).getId());
        hardware.setAttribute("Mode", (*iter).getMode()); //full-duplex
        hardware.setAttribute("BandWidth", (*iter).getBandwith());
        hardware.setAttribute("Mac", (*iter).getMac());
        hardware.setAttribute("Type", (*iter).getType());
        hardware.setAttribute("UploadPortNumber", (qint32) (*iter).getUploadPortNumber());

        // and now the ports
        QDomElement ports = doc->createElement("Ports");
        QList<Port>::const_iterator portIter = (*iter).getPorts().begin();
        hardware.setAttribute("Ports",  (*iter).getPorts().count());

        while (portIter != (*iter).getPorts().end()) {
            QDomElement port = doc->createElement("Port");
            port.setAttribute("CableId", (*portIter).getCableId());
            port.setAttribute("PortNr", (*portIter).getPortNr());
            port.setAttribute("Speed", (*portIter).getSpeed());
            ports.appendChild(port);
            portIter++;
        }
        hardware.appendChild(ports);
        switches.appendChild(hardware);
        iter++;
    }
}

void XMLGenerator::addLinks(const Links& myLinks)
{
    QDomElement root = doc->documentElement();

    QList<Link>::const_iterator linkIter = myLinks.begin();
    // create the links subelements 
    QDomElement links = doc->createElement("Links");

    while (linkIter != myLinks.end()) {
        // for every link element, create a xml element
        QDomElement link = doc->createElement("Link");
        link.setAttribute("Delay", (*linkIter).getDelay());
        link.setAttribute("FromDeviceId", (*linkIter).getFromDevice());
        link.setAttribute("ToDeviceId", (*linkIter).getToDevice());
        link.setAttribute("FromPort", (*linkIter).getFromPort());
        link.setAttribute("ToPort", (*linkIter).getToPort());
        links.appendChild(link);
        linkIter++;
   }
   root.appendChild(links);
}

void XMLGenerator::addMessages(const Messages& myMessages)
{
    QDomElement root = doc->documentElement();

    QList<Message>::const_iterator msgIter = myMessages.begin();
    // create the message subelements
    QDomElement messages = doc->createElement("Messages");

    while (msgIter != myMessages.end()) {
        QDomElement msg = doc->createElement("Message");
        msg.setAttribute("MsgId", (*msgIter).getMsgId());
        msg.setAttribute("SenderId", (*msgIter).getSenderId());
        msg.setAttribute("ReceiverId", (*msgIter).getReceiverId());
        messages.appendChild(msg);
        msgIter++;
   }
   root.appendChild(messages);
}

const QDomDocument * XMLGenerator::getXML() const
{
    return doc;
}
