//
// Copyright (C) 2006 Henning Westerholt
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//  
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along
// with this program; if not, write to the Free Software Foundation, Inc.,
// 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
//

#ifndef _XMLGENERATOR_H_
#define _XMLGENERATOR_H_

class QDomDocument;
class Network;
class Links;
class Messages;

class XMLGenerator
{
public:
    XMLGenerator();
    ~XMLGenerator();
    void addNetwork(const Network& network);
    void addLinks(const Links& links);
    void addMessages(const Messages& messages);
    const QDomDocument * getXML() const;

private:
    // disable compiler generated copy constructor and operator=
    XMLGenerator(const XMLGenerator&);
    void operator=(const XMLGenerator& other); 

    QDomDocument * doc;
};

#endif
