//
// Copyright (C) 2006 Henning Westerholt
// Copyright (C) 2004 Andras Varga
// Copyright (C) 2000 Institut fuer Telematik, Universitaet Karlsruhe
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//


#ifndef __ETHERSTREAMAPP_H__
#define __ETHERSTREAMAPP_H__

#include <omnetpp.h>
#include "INETDefs.h"
#include "Ieee802Ctrl_m.h"

/**
 * Ethernet stream application. See NED for more info.
 */
class INET_API EtherStreamApp : public cSimpleModule
{
    // send parameters
    long seqNum;
    cPar *msgLength;
    cPar *waitTime;

    int localSAP;
    int remoteSAP;
    MACAddress destMACAddress;

    // receive statistics
    long packetsSent;
    long packetsReceived;
    cOutVector eedVector;
    cStdDev eedStats;

  protected:
    virtual void initialize(const int stage);
    virtual int numInitStages() const {return 2;}
    virtual void handleMessage(cMessage *msg);
    virtual void finish();

    MACAddress resolveDestMACAddress();

    void sendPacket();
    void receivePacket(cMessage *msg);
    void registerDSAP(const int dsap);
};

#endif
