//
// Copyright (C) 2006 Henning Westerholt
// Copyright (C) 2000 Institut fuer Telematik, Universitaet Karlsruhe
// Copyright (C) 2004-2005 Andras Varga
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//

// adapted from IPTrafGen.cc


#include <omnetpp.h>
#include "TDMATrafGen.h"

Define_Module(TDMATrafSink);


void TDMATrafSink::initialize()
{
    numReceived = 0;
    WATCH(numReceived);
}

void TDMATrafSink::handleMessage(cMessage *msg)
{
    processPacket(msg);

    if (ev.isGUI())
    {
        char buf[32];
        sprintf(buf, "rcvd: %d pks", numReceived);
        displayString().setTagArg("t",0,buf);
    }

}

void TDMATrafSink::printPacket(cMessage *msg)
{
//    int protocol = -1;
//     IPvXAddress src, dest;
//     if (dynamic_cast<IPControlInfo *>(msg->controlInfo())!=NULL)
//     {
//         IPControlInfo *ctrl = (IPControlInfo *)msg->controlInfo();
//         src = ctrl->srcAddr();
//         dest = ctrl->destAddr();
//         protocol = ctrl->protocol();
//     }
//     else if (dynamic_cast<IPv6ControlInfo *>(msg->controlInfo())!=NULL)
//     {
//         IPv6ControlInfo *ctrl = (IPv6ControlInfo *)msg->controlInfo();
//         src = ctrl->srcAddr();
//         dest = ctrl->destAddr();
//         protocol = ctrl->protocol();
//     }

    ev  << msg << endl;
    ev  << "Payload length: " << msg->byteLength() << " bytes" << endl;
    //if (protocol!=-1) //FIXME
        //ev  << "src: " << src << "  dest: " << dest << "  protocol=" << protocol << "\n";
}

void TDMATrafSink::processPacket(cMessage *msg)
{
    EV << "Received packet: ";
    printPacket(msg);
    delete msg;

    numReceived++;
}



//===============================================


Define_Module(TDMATrafGen);

//int IPTrafGen::counter;

void TDMATrafGen::initialize(int stage)
{
    // wait for Ethernet Autonegoation etc..
    if (stage!=3)
        return;

    TDMATrafSink::initialize();
    counter =  numSent = 0;
    packetInterval = 0;
    WATCH(numSent);

    msgByteLength = par("packetLength");
    numPackets = par("numPackets");
    simtime_t startTime = par("startTime");
    packetInterval = par("packetInterval");

    //if (destAddresses.empty())
        //return;

    cMessage *timer = new cMessage("sendTimer");
    scheduleAt(startTime, timer);
}

void TDMATrafGen::sendPacket()
{
    char msgName[32];
    sprintf(msgName,"appData-%d", counter++);

    cMessage *payload = new cMessage(msgName);
    payload->setByteLength(msgByteLength);
    EV << "Sending packet: ";
    printPacket(payload);

    send(payload, "out");
    numSent++;
}

void TDMATrafGen::handleMessage(cMessage *msg)
{
    if (msg->isSelfMessage())
    {
        // send, then reschedule next sending
        sendPacket();

        if (numSent<numPackets)
            scheduleAt(simTime() + packetInterval, msg);
    }
    else
    {
        // process incoming packet
        processPacket(msg);
    }

    if (ev.isGUI())
    {
        char buf[40];
        sprintf(buf, "rcvd: %d pks\nsent: %d pks", numReceived, numSent);
        displayString().setTagArg("t",0,buf);
    }
}
