/***************************************************************************
                          RTPAVProfileSampleBasedAudioSender.h  -  description
                             -------------------
    begin                : Sat Sep 21 2002
    copyright            : (C) 2002 by
    email                :
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/** \file RTPAVProfileSampleBasedAudioSender.h
 * This file contains the definition of the class RTPAVProfileSampleBasedAudioSender.
 */


#ifndef __RTPAVPROFILESAMPLEBASEDAUDIOSENDER_H__
#define __RTPAVPROFILESAMPLEBASEDAUDIOSENDER_H__


#include "RTPPayloadSender.h"


/**
 * The class RTPAVProfileSampleBasedAudioSender is a base class for modules
 * sending sample based audio as defined in the RTP audio/video profile.
 * For reading audio files it used libaudiofile.
 * Subclasses must provide a method initialize() to set parameters like
 * sampling rate, sample width and number of channels.
 */
class INET_API RTPAVProfileSampleBasedAudioSender : public RTPPayloadSender
{
    protected:

        /**
         * File handle for the audio file.
         */
        AFfilehandle _audioFile;

        /**
         * The time this sender module got initialized. Used to calculate time stamps.
         */
        simtime_t _startTime;

        /**
         * The sampling rate of the audio. Must be set by subclasses in initialize().
         */
        int _samplingRate;

        /**
         * The width of a sample of one channel in bits. Possibly values are 8, 16 and 24.
         * Must be set by subclasses in initialize().
         */
        int _sampleWidth;

        /**
         * The number of different audio channels. Must be set by subclasses in initialize().
         */
        int _numberOfChannels;


        /**
         * Called when this sender module receives a message initializeSenderModule.
         */
        virtual void initializeSenderModule(RTPInnerPacket *);

        virtual void openSourceFile(const char *fileName);
        virtual void closeSourceFile();

        virtual void play();
        virtual void stop();
        virtual void seekTime(simtime_t moment);
        virtual void seekByte(int position);

        virtual bool sendPacket();

};

#endif